import React from 'react';
import {SpreadSheets, Worksheet, Column} from '@mescius/spread-sheets-react';
import './Style.css'
import dataService from '../dataService'

function QuickStart(props) {
    const spreadBackColor = 'aliceblue';
    const sheetName = 'Person Address';
    const hostStyle = {
        top: '240px',
        bottom: '10px'
    };
    const autoGenerateColumns = false;
    const data = dataService.getPersonAddressData();

    return (
        <div className="componentContainer" style={props.style}>
            <h3>Quick Start</h3>
            <div>
                Steps for getting started with the SpreadJS in React applications:
                <div>
                    <p>1. Add reference files in your React application.</p>
                    <p>2. Add a component to provide data and logic.</p>
                    <p>3. Bind data and some other options of spread.</p>
                    <p>4. Add some css to customize appearance.</p>
                </div>
            </div>
            <div className="spreadContainer" style={hostStyle}>
                <SpreadSheets backColor={spreadBackColor}>
                    <Worksheet name={sheetName} dataSource={data}
                                autoGenerateColumns={autoGenerateColumns}>
                        <Column width={150} dataField="Name"/>
                        <Column width={150} dataField="CountryRegionCode"/>
                        <Column width={100} dataField="City"/>
                        <Column width={200} dataField="AddressLine"/>
                        <Column width={100} dataField="PostalCode"/>
                    </Worksheet>
                </SpreadSheets>
            </div>
        </div>

    );
}

export default QuickStart