export function destroyQuill(quillInstance, containerElement) {
    quillInstance.off('text-change');
    quillInstance.off('selection-change');

    if (quillInstance.theme && quillInstance.theme.modules.toolbar) {
        const toolbar = quillInstance.theme.modules.toolbar.container;
        if (toolbar) toolbar.remove();
    }

    const editorElement = containerElement.querySelector('.ql-editor');
    if (editorElement) {
        editorElement.innerHTML = ''; // 清空内容
        containerElement.classList.remove('ql-container', 'ql-snow'); // 移除 Quill 的样式类
    }

    quillInstance = null;
}