import { createBindKonva, removeBindKonva, refreshKonva } from './create-painting';

export class UserManager {
    private mockUsers = [
        {
            id: '1',
            name: 'User1',
            color: 'red',
        },
        {
            id: '2',
            name: 'User2',
            color: 'green',
        },
        {
            id: '3',
            name: 'User3',
            color: 'blue',
        },
        {
            id: '4',
            name: 'User4',
            color: 'purple',
        },
    ];
    private existUsers: string[] = [];
    private dom: HTMLDivElement;
    constructor(domId: string) {
        this.dom = document.getElementById(domId) as HTMLDivElement;
    }
    addUser () {
        const userId = this.getMockUserId();
        const index = this.existUsers.length;
        if (index < 4) {
            this.existUsers.push(userId);
            this.updateUI();
            createBindKonva(`root${index + 1}`, `user${index + 1}` , this.mockUsers[index]);
            refreshKonva();
        }
    }
    removeUser (userId: string) {
        this.existUsers = this.existUsers.filter(item => item !== userId);
        this.updateUI();
        removeBindKonva(userId);
        refreshKonva();
    }
    private updateUI () {
        const count = this.existUsers.length;
        if (count > 1) {
            document.getElementById("wrapper1").style.width = '50%';
            document.getElementById("wrapper2").style.display = 'block';
        } else {
            document.getElementById("wrapper1").style.width = '100%';
            document.getElementById("wrapper2").style.display = 'none';
        }
        if (count > 3) {
            document.getElementById("wrapper3").style.width = '50%';
            document.getElementById("wrapper4").style.display = 'block';
        } else {
            document.getElementById("wrapper3").style.width = '50%';
            document.getElementById("wrapper4").style.display = 'none';
        }
        if(count < 3) {
            document.getElementById("container1").style.height = 'calc(100% - 40px)';
            document.getElementById("container2").style.display = 'none';
        } else {
            document.getElementById("container1").style.height = 'calc(50% - 20px)';
            document.getElementById("container2").style.display = 'flex';
        }
        this.renderUserManager();
    }
    private getMockUserId (): string {
        for (let i = 0; i < this.mockUsers.length; i++) {
            const id = this.mockUsers[i].id;
            if (this.existUsers.findIndex(item => item === id) === -1) {
                return id;
            }
        }
    }
    private getUserInfo (userId: string) {
        return this.mockUsers.filter(item => item.id === userId)?.[0];
    }
    private renderUserManager () {
        if (!this.dom) {
            return;
        }
        // clear
        while (this.dom.firstChild) {
            this.dom.removeChild(this.dom.firstChild);
        }
        // add user
        this.existUsers.forEach((item, index) => {
            this.createUser(item, index !== 0 && index === this.existUsers.length - 1);
        })
        // add + button
        this.createAddButton();
    }
    private createUser (userId: string, addRemoveBtn: boolean) {
        const userInfo = this.getUserInfo(userId);
        // Create user box element
        const userBox = document.createElement('div');
        userBox.className = 'user-box';
        userBox.textContent = userInfo.name;
        userBox.style.cursor = "normal";
        if (addRemoveBtn) {
            userBox.style.cursor = "pointer";
            // Create delete button
            const deleteBtn = document.createElement('span');
            deleteBtn.className = 'delete-btn';
            // deleteBtn.textContent = 'X';

            // Add click event to delete button
            userBox.addEventListener('click', () => {
                this.removeUser(userId);
            });
            // Append delete button to user box
            userBox.appendChild(deleteBtn);
        }
        this.dom.appendChild(userBox);
    }
    private createAddButton () {
        if (this.existUsers.length < this.mockUsers.length) {
            const addButton = document.createElement('button');
            addButton.textContent = '+';
            addButton.className = 'add-user-button';

            // Add click event to the add button
            addButton.addEventListener('click', () => {
                this.addUser();
            });

            this.dom.appendChild(addButton);
        }
    }
}