export enum MessageType {
    CREATE_SPREAD = 'CREATE_SPREAD',
    DESTROY_SPREAD = 'DESTROY_SPREAD',

    IFRAME_READY = 'IFRAME_READY',
    SPREAD_READY = 'SPREAD_READY'
}

export interface IUser {
    id: string;
    name: string;
    color?: string;
}

export interface ICreateSpreadMessage {
    type: MessageType.CREATE_SPREAD;
    payload: {
        user: IUser;
        roomId: string;
    };
}

export interface IDestroySpreadMessage {
    type: MessageType.DESTROY_SPREAD;
}

export interface IIframeReadyMessage {
    type: MessageType.IFRAME_READY;
}

export interface ISpreadReadyMessage {
    type: MessageType.SPREAD_READY;
    payload: {
        userId: string;
    };
}

export type ParentToChildMessage = ICreateSpreadMessage | IDestroySpreadMessage;
export type ChildToParentMessage = IIframeReadyMessage | ISpreadReadyMessage;
export type IMessage = ParentToChildMessage | ChildToParentMessage;
