import "@mescius/spread-sheets/styles/gc.spread.sheets.excel2013white.css";
import "@mescius/spread-sheets-designer/styles/gc.spread.sheets.designer.light.min.css";

import * as GC from '@mescius/spread-sheets';
import '@mescius/spread-sheets-shapes';
import '@mescius/spread-sheets-charts';
import '@mescius/spread-sheets-slicers';
import '@mescius/spread-sheets-barcode';
import '@mescius/spread-sheets-print';
import '@mescius/spread-sheets-pdf';
import '@mescius/spread-sheets-formula-panel';
import '@mescius/spread-sheets-pivot-addon';

// import resources
import '@mescius/spread-sheets-designer-resources-en';

import * as GCD from "@mescius/spread-sheets-designer";
import '@mescius/spread-sheets-collaboration-addon';

import { Client, Connection } from "@mescius/js-collaboration-client";
import * as OT from "@mescius/js-collaboration-ot-client";
import { Presence } from "@mescius/js-collaboration-presence-client";
import { bind, bindPresence, IChangeSet, IPresence, type } from "@mescius/spread-sheets-collaboration-client";
import { SharedDoc } from "@mescius/js-collaboration-ot-client";

// add license
// GCD.Spread.Sheets.Designer.LicenseKey = '';
// GC.Spread.Sheets.LicenseKey = '';

import {
    MessageType,
    ICreateSpreadMessage,
    IUser
} from './message-protocol';
OT.TypesManager.register(type);

let currentDesigner: GCD.Spread.Sheets.Designer.Designer | null = null;
let currentDoc: SharedDoc<any, IChangeSet> | null = null;
let currentConn: Connection | null = null;

interface IDom extends HTMLElement {
    _mouseoverHandler: () => void;
    _mouseoutHandler: () => void;
}

function clearUserPresence() {
    const presenceDiv = document.getElementById('user-presence');
    if (!presenceDiv) return;

    while (presenceDiv.firstChild) {
        const child = presenceDiv.firstChild as IDom;
        if (child._mouseoverHandler) {
            child.removeEventListener('mouseover', child._mouseoverHandler);
        }
        if (child._mouseoutHandler) {
            child.removeEventListener('mouseout', child._mouseoutHandler);
        }
        presenceDiv.removeChild(child);
    }
}

function renderPresences(presences: IPresence[]) {
    const presenceDiv = document.getElementById('user-presence');
    if (!presenceDiv) return;

    clearUserPresence();

    presences.forEach(presence => {
        const user = presence.user;
        const circle = document.createElement('div') as unknown as IDom;
        circle.className = 'presence-item';
        circle.style.backgroundColor = user.color || '#007bff';
        circle.textContent = user.name.charAt(0).toUpperCase();

        const mouseoverHandler = () => {
            circle.style.width = '97px';
            circle.style.padding = "0px 5px";
            circle.textContent = user.name.charAt(0).toUpperCase() + user.name.slice(1);
        };

        const mouseoutHandler = () => {
            circle.style.width = '24px';
            circle.style.padding = "0px";
            circle.textContent = user.name.charAt(0).toUpperCase();
        };

        circle._mouseoverHandler = mouseoverHandler;
        circle._mouseoutHandler = mouseoutHandler;

        circle.addEventListener('mouseover', mouseoverHandler);
        circle.addEventListener('mouseout', mouseoutHandler);

        presenceDiv.appendChild(circle);
    });
}

function createConfig(GC: any) {
    const config = GC.Spread.Sheets.Designer.DefaultConfig;

    delete config.fileMenu;

    const insertTab = config.ribbon.find((r: any) => r.id === 'insert');
    if (insertTab) {
        insertTab.buttonGroups = insertTab.buttonGroups.map((bg: any) => {
            if (bg.label && bg.commandGroup?.children) {
                bg.commandGroup.children = bg.commandGroup.children.map((child: any) => {
                    if (child.command === 'insertTable') {
                        return {
                            command: child.command,
                            type: undefined
                        };
                    }
                    return child;
                });
            }
            return bg;
        });
    }

    const dataTab = config.ribbon.find((r: any) => r.id === 'data');
    if (dataTab) {
        dataTab.buttonGroups = dataTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }

    const tableDesignTab = config.ribbon.find((r: any) => r.id === 'tableDesign');
    if (tableDesignTab) {
        tableDesignTab.buttonGroups = tableDesignTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }
    return config;
}

const mockUsers = [
    { id: '1', name: 'User1', color: 'red' },
    { id: '2', name: 'User2', color: 'green' },
    { id: '3', name: 'User3', color: 'blue' },
    { id: '4', name: 'User4', color: 'purple' },
];

function createSpread(user: IUser, roomId: string) {
    const hostId = 'spread-host';
    const designer = new GCD.Spread.Sheets.Designer.Designer(hostId);
    GC.Spread.Common.UserManager.configure({
        get: async (id: string) => {
            return mockUsers.find((item) => item.id === id);
        },
        search: async (query: string) => {
            return mockUsers.filter((item) => item.name.indexOf(query) > -1);
        },
    });
    const config = createConfig(GCD);
    designer.setConfig(config);

    const workbook = designer.getWorkbook() as any;
    const conn = new Client().connect(roomId);
    const doc = new OT.SharedDoc<any, IChangeSet>(conn);
    const presence = new Presence<IPresence>(conn);

    bind(workbook, doc);
    bindPresence(workbook, presence, user, {
        onPresencesUpdate: (presences) => {
            renderPresences(presences);
        }
    });

    currentDesigner = designer;
    currentDoc = doc;
    currentConn = conn;

    window.parent.postMessage({
        type: MessageType.SPREAD_READY,
        payload: { userId: user.id }
    }, '*');
}

function destroySpread() {
    if (currentConn) {
        currentConn.close();
    }
    if (currentDoc) {
        currentDoc.destroy();
    }
    if (currentDesigner) {
        currentDesigner.destroy();
    }

    clearUserPresence();

    currentDesigner = null;
    currentDoc = null;
    currentConn = null;
}

window.addEventListener('message', (event) => {
    const message = event.data;

    switch (message.type) {
        case MessageType.CREATE_SPREAD:
            createSpread((message as ICreateSpreadMessage).payload.user, (message as ICreateSpreadMessage).payload.roomId);
            break;

        case MessageType.DESTROY_SPREAD:
            destroySpread();
            break;
    }
});

window.parent.postMessage({ type: MessageType.IFRAME_READY }, '*');
