/* eslint-disable no-undef */
/* eslint-disable @typescript-eslint/no-var-requires */
// eslint-disable-next-line @typescript-eslint/no-require-imports
const path = require('path');

module.exports = {
    entry: './src/client/main.tsx',
    mode: 'production',
    module: {
        rules: [
            {
                test: /\.(ts|tsx|mts)$/,
                use: 'ts-loader',
                exclude: [
                    /node_modules/,
                ],
            },
            {
                test: /\.(mts|mjs)$/,
                type: 'javascript/esm'
            },
            {
                test: /\.css$/,
                use: ['style-loader', 'css-loader'],
            },
            {
                test: /.(svg|png|jpg)$/,
                use: 'file-loader',
            },
            {
                test: /\.json$/,
                loader: 'json-loader',
                type: 'javascript/auto',
            },
        ],
    },
    resolve: {
        extensions: ['.tsx', '.ts', '.js', 'json'],
    },
    output: {
        filename: 'main.js',
        path: path.resolve(__dirname, 'public'),
    },
    optimization: {
        minimize: false
    },
};