import { IMiddleware } from '@mescius/js-collaboration';
import { IDocSubmitMiddlewareContext } from '@mescius/js-collaboration-ot';
import { Role } from '../db/doc-user-role.mjs';

export function submitOpAuth(): IMiddleware<IDocSubmitMiddlewareContext<any, any>> {
    return async (context, next) => {
        const role = (context.connection?.tags.get('user') as { role: Role })?.role;
        if (role === Role.viewer) {
            await next('no permission');
        } else {
            await next();
        }
    };
}
