import { randomColor, uuid } from '../utils.mjs';
import { db } from './config.mjs';

export class UserDb {

    get(username: string): Promise<IUserRecord | undefined> {
        return new Promise((resolve, reject) => {
            db.get('SELECT * FROM users WHERE username = ?', [username], (err, row) => {
                if (err) {
                    console.error(err);
                    return reject(err);
                }

                resolve(row as IUserRecord | undefined);
            });
        });
    }

    getById(id: string): Promise<IUserRecord | undefined> {
        return new Promise((resolve, reject) => {
            db.get('SELECT id, username, color FROM users WHERE id = ?', [id], (err, row) => {
                if (err) {
                    console.error(err);
                    return reject(err);
                }

                resolve(row as IUserRecord | undefined);
            });
        });
    }

    insert(username: string, password: string): Promise<IUserRecord> {
        return new Promise((resolve, reject) => {
            const id = uuid();
            const color = randomColor();
            // 在数据库中插入新用户
            db.run('INSERT INTO users (id, username, password, color) VALUES (?, ?, ?, ?)', [id, username, password, color], (err) => {
                if (err) {
                    console.error(err);
                    return reject('Username already exists');
                }

                resolve({ id, username, password, color });
            });
        });
    }

    all(): Promise<IUserRecord[]> {
        return new Promise((resolve, reject) => {
            db.all<IUserRecord>(`SELECT id, username, password, color FROM users`, (err, row) => {
                if (err) {
                    console.error(err);
                    return reject(err);
                }

                resolve(row);
            });
        });
    }
}

export interface IUserRecord {
    id: string;
    username: string;
    password?: string;
    color?: string;
}