import { redirect } from "react-router-dom";
import { setLocalUser, userReq } from "../request/user";

export const loader = async () => {
    const token = new URLSearchParams(window.location.search).get('token');
    if (token) {
        setLocalUser(token);
        window.location.href = '/all-files';
        return;
    }

    const user = userReq.currentUser();
    if (!user) {
        const path = location.pathname;
        return redirect(`/login?target=${path}`);
    }
    return user;
};
