/* eslint-disable @typescript-eslint/no-explicit-any */
import * as GC from "@mescius/spread-sheets";
import '@mescius/spread-sheets-shapes';
import '@mescius/spread-sheets-charts';
import '@mescius/spread-sheets-slicers';
import '@mescius/spread-sheets-barcode';
import '@mescius/spread-sheets-print';
import '@mescius/spread-sheets-pdf';
import '@mescius/spread-sheets-formula-panel';
import "@mescius/spread-sheets-pivot-addon";

// import resources
import "@mescius/spread-sheets-designer-resources-en";

import * as GCD from "@mescius/spread-sheets-designer";
import "@mescius/spread-sheets-collaboration-addon";
import "@mescius/spread-sheets-collaboration";
import "@mescius/spread-sheets/styles/gc.spread.sheets.excel2013white.css";
import "@mescius/spread-sheets-designer/styles/gc.spread.sheets.designer.light.min.css";

import { useEffect, useRef } from "react";
import { removeFileMenuCategories } from "../collaboration-editors/util";

// import { config as mainConfig } from "../../config";
// add license
// GCD.Spread.Sheets.Designer.LicenseKey = mainConfig.licenses.designer;
// GC.Spread.Sheets.LicenseKey = mainConfig.licenses.runtime;

const GCNameSpace = GC.Spread.Sheets;

// for debug
(window as any).GC = GC;
(window as any).GCD = GCD;
export default function SpreadSheetsViewer(props: { data: any[] }) {
    const ref = useRef<HTMLDivElement>(null);
    const { data } = props;

    useEffect(() => {
        const div = ref.current as HTMLDivElement;
        removeFileMenuCategories(GCD);
        const designer = new GCD.Spread.Sheets.Designer.Designer(div);
        const config = createConfig();
        designer.setConfig(config);
        const workbook = designer.getWorkbook() as any;
        workbook.collaboration.setPermission({
            mode: GCNameSpace.Collaboration.BrowsingMode.view
        });
        // for debug
        (window as any).workbook = workbook;
        (window as any).spread = workbook;
        workbook.collaboration.fromSnapshot(data);
        return () => {
            designer.destroy();
            workbook.destroy();
        };
    }, [data]);

    return (
        <div ref={ref} style={{height: "100%"}}></div>
    )
}

function createConfig() {
    const config = GCD.Spread.Sheets.Designer.DefaultConfig as any;

    // Remove File menu
    delete config.fileMenu;

    // Remove Table dropdown in Insert page (make it a simple button)
    const insertTab = config.ribbon.find((r: any) => r.id === 'insert');
    if (insertTab) {
        insertTab.buttonGroups = insertTab.buttonGroups.map((bg: any) => {
            if (bg.label && bg.commandGroup?.children) {
                bg.commandGroup.children = bg.commandGroup.children.map((child: any) => {
                    if (child.command === 'insertTable') {
                        return {
                            command: child.command,
                            type: undefined
                        };
                    }
                    return child;
                });
            }
            return bg;
        });
    }

    // Remove Data Binding section from Data page
    const dataTab = config.ribbon.find((r: any) => r.id === 'data');
    if (dataTab) {
        dataTab.buttonGroups = dataTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }

    // Remove Table Binding section from Table Designer page
    const tableDesignTab = config.ribbon.find((r: any) => r.id === 'tableDesign');
    if (tableDesignTab) {
        tableDesignTab.buttonGroups = tableDesignTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }
    return config;
}