import React from 'react';
import { Button, Form, Input } from 'antd';
// import { config } from '../../config';
import config from '../../../../config/default.json'
export type ILoginValues = {
    username?: string;
    password?: string;
};

interface ILoginProps {
    onLogin: (values: ILoginValues) => void;
    onSignUp: (values: ILoginValues) => void;
}

export const Login: React.FC<ILoginProps> = (props) => {
    const [form] = Form.useForm();

    const onSignUp = () => {
        const username = form.getFieldValue('username');
        const password = form.getFieldValue('password');
        props.onSignUp({ username, password });
    }

    const github = config.oauth.github;

    return (
        <Form
            name="login"
            labelCol={{ span: 8 }}
            wrapperCol={{ span: 16 }}
            style={{ maxWidth: 600 }}
            form={form}
            onFinish={props.onLogin}
        >
            <Form.Item<ILoginValues>
                label="Username"
                name="username"
                rules={[{ required: true, message: 'Please input your username!' }]}
            >
                <Input />
            </Form.Item>

            <Form.Item<ILoginValues>
                label="Password"
                name="password"
                rules={[{ required: true, message: 'Please input your password!' }]}
            >
                <Input.Password />
            </Form.Item>

            <Form.Item wrapperCol={{ offset: 8, span: 16 }}>
                <Button type="primary" htmlType="submit">
                    Login
                </Button>
                <Button type="link" onClick={onSignUp}>
                    Sign Up
                </Button>
                <Button type="link">
                    <a href={`https://github.com/login/oauth/authorize?client_id=${github.clientId}&redirect_uri=${github.redirectUri}`}>
                        GitHub Login
                    </a>
                </Button>
            </Form.Item>
        </Form>
    )
};