import * as GC from "@mescius/spread-sheets";
import '@mescius/spread-sheets-shapes';
import '@mescius/spread-sheets-charts';
import '@mescius/spread-sheets-slicers';
import '@mescius/spread-sheets-barcode';
import '@mescius/spread-sheets-print';
import '@mescius/spread-sheets-pdf';
import '@mescius/spread-sheets-formula-panel';
import "@mescius/spread-sheets-pivot-addon";

// import resources
import "@mescius/spread-sheets-designer-resources-en";

import * as GCD from "@mescius/spread-sheets-designer";
import "@mescius/spread-sheets-collaboration-addon";
import "@mescius/spread-sheets-collaboration";
import "@mescius/spread-sheets/styles/gc.spread.sheets.excel2013white.css";
import "@mescius/spread-sheets-designer/styles/gc.spread.sheets.designer.light.min.css";

import * as OT from '@mescius/js-collaboration-ot-client';
import { Presence } from "@mescius/js-collaboration-presence-client";
import { bind, bindPresence, IPresence, IChangeSet, type, BrowsingMode } from '@mescius/spread-sheets-collaboration-client'
import { useEffect, useRef } from "react";
import { removeFileMenuCategories } from './util';
import { IDoc } from '../../request/doc';
import { IUser, userReq } from '../../request/user';
import { connect } from '../../request/req';
import {CustomHeader, PageType} from "../Header";

// import { config as mainConfig } from "../../config";
// add license
// GCD.Spread.Sheets.Designer.LicenseKey = mainConfig.licenses.designer;
// GC.Spread.Sheets.LicenseKey = mainConfig.licenses.runtime;

// for debug
(window as any).GC = GC;
(window as any).GCD = GCD;
function convertUser(user: IUser) {
    const { id, username, color } = user;
    return { id, name: username, color };
}

OT.TypesManager.register(type);

export default function SharedSpreadSheets(props: { doc: IDoc, user: IUser, readonly: boolean }) {
    const ref = useRef<HTMLDivElement>(null);
    const { doc, user, readonly } = props;


    useEffect(() => {
        const div = ref.current as HTMLDivElement;
        const conn = connect(doc.id);
        const sharedDoc = new OT.SharedDoc<any, IChangeSet>(conn);
        const presence = new Presence<IPresence>(conn);
        removeFileMenuCategories(GCD);
        const designer = new GCD.Spread.Sheets.Designer.Designer(div);
        const config = createConfig();
        designer.setConfig(config);
        const workbook = designer.getWorkbook() as any;
        // for debug
        (window as any).workbook = workbook;
        (window as any).spread = workbook;
        GC.Spread.Common.UserManager.configure({
            get: async (userID: string) => {
                try {
                    const result = await userReq.getUserInfoById(userID);
                    return convertUser(result);
                } catch (e) {
                }
            },
            search: async (query: string) => {
                try {
                    const users = await userReq.search(query);
                    return users.map(convertUser);
                } catch (e) {
                }
            }
        });
        bind(workbook, sharedDoc);
        bindPresence(workbook, presence, {
            id: user.id,
            name: user.username,
            permission: {
                mode: readonly ? BrowsingMode.view : BrowsingMode.edit
            }
        });

        return () => {
            sharedDoc.destroy();
            sharedDoc.connection.close();
            designer.destroy();
            workbook.destroy();
        };
    }, [doc.id, user])

    return (
        <CustomHeader type={PageType.Open} doc={doc}>
            <div ref={ref} style={{ width: '100%', height: "100%", border: "1px solid #ccc" }}></div>
        </CustomHeader>
    )
}

function createConfig() {
    const config = GCD.Spread.Sheets.Designer.DefaultConfig as any;

    // Remove File menu
    delete config.fileMenu;

    // Remove Table dropdown in Insert page (make it a simple button)
    const insertTab = config.ribbon.find((r: any) => r.id === 'insert');
    if (insertTab) {
        insertTab.buttonGroups = insertTab.buttonGroups.map((bg: any) => {
            if (bg.label && bg.commandGroup?.children) {
                bg.commandGroup.children = bg.commandGroup.children.map((child: any) => {
                    if (child.command === 'insertTable') {
                        return {
                            command: child.command,
                            type: undefined
                        };
                    }
                    return child;
                });
            }
            return bg;
        });
    }

    // Remove Data Binding section from Data page
    const dataTab = config.ribbon.find((r: any) => r.id === 'data');
    if (dataTab) {
        dataTab.buttonGroups = dataTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }

    // Remove Table Binding section from Table Designer page
    const tableDesignTab = config.ribbon.find((r: any) => r.id === 'tableDesign');
    if (tableDesignTab) {
        tableDesignTab.buttonGroups = tableDesignTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }
    return config;
}
