import * as GC from '@mescius/spread-sheets';
import '@mescius/spread-sheets-shapes';
import '@mescius/spread-sheets-charts';
import '@mescius/spread-sheets-slicers';
import '@mescius/spread-sheets-barcode';
import '@mescius/spread-sheets-print';
import '@mescius/spread-sheets-pdf';
import '@mescius/spread-sheets-formula-panel';
import '@mescius/spread-sheets-pivot-addon';

// import resources
import '@mescius/spread-sheets-designer-resources-en';

import * as GCD from '@mescius/spread-sheets-designer';
import '@mescius/spread-sheets-collaboration-addon';
import "@mescius/spread-sheets/styles/gc.spread.sheets.excel2013white.css";
import "@mescius/spread-sheets-designer/styles/gc.spread.sheets.designer.light.min.css";

import { Client } from "@mescius/js-collaboration-client";
import * as OT from "@mescius/js-collaboration-ot-client";
import { IChangeSet, type } from '@mescius/spread-sheets-collaboration-client';
import ReactDOM from "react-dom/client";
import React from "react";
import {Header} from './bind-syn-status';

// add license
// GCD.Spread.Sheets.Designer.LicenseKey = '';
// GC.Spread.Sheets.LicenseKey = '';

OT.TypesManager.register(type);

const designer = new GCD.Spread.Sheets.Designer.Designer("root");
const workbook = designer.getWorkbook() as any;
const conn = new Client().connect('room1');
const doc = new OT.SharedDoc<any, IChangeSet>(conn);
const config = createConfig();
designer.setConfig(config);
ReactDOM.createRoot(document.getElementById('header')!).render(
    <Header workbook={workbook} doc={doc} />
)

function createConfig() {
    const config = GCD.Spread.Sheets.Designer.DefaultConfig as any;

    // Remove File menu
    delete config.fileMenu;

    // Remove Table dropdown in Insert page (make it a simple button)
    const insertTab = config.ribbon.find((r: any) => r.id === 'insert');
    if (insertTab) {
        insertTab.buttonGroups = insertTab.buttonGroups.map((bg: any) => {
            if (bg.label && bg.commandGroup?.children) {
                bg.commandGroup.children = bg.commandGroup.children.map((child: any) => {
                    if (child.command === 'insertTable') {
                        return {
                            command: child.command,
                            type: undefined
                        };
                    }
                    return child;
                });
            }
            return bg;
        });
    }

    // Remove Data Binding section from Data page
    const dataTab = config.ribbon.find((r: any) => r.id === 'data');
    if (dataTab) {
        dataTab.buttonGroups = dataTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }

    // Remove Table Binding section from Table Designer page
    const tableDesignTab = config.ribbon.find((r: any) => r.id === 'tableDesign');
    if (tableDesignTab) {
        tableDesignTab.buttonGroups = tableDesignTab.buttonGroups.filter((buttonGroup: any) =>
            !(buttonGroup.label?.toLowerCase().includes('binding'))
        );
    }
    return config;
}