# Migration tool for Document Solutions
Effective from 01-Nov-2023, GrapeCity Documents is now Document Solutions. This tool can batch update the GrapeCity Documents package references in your projects to use the new packages, and save the updated projects.

Note: The namespaces and type names remain the same, your code does not need to be changed. This tool will only replace the package references.

## Capabilities
- Replace package id and version in `<PackageReference>` in `.csproj`, `.vbproj` and `.fsproj` files. Both MSBuild 2003 and .NET SDK projects are supported. 
- Replace group id, package name and version of Document Solutions package references in Gradle and Maven projects. For Gradle projects, the reference format must match the pattern used by https://mvnrepository.com/.
- Create backup files.
- Troubleshooting using migration report:
  - The migration report is a table with the following columns:
    1. Severity: it can be an error, warning, or information. Please pay attention to errors and warnings.
    2. ID: it is useful when you're looking for technical support. When the migration tool throws an exception, it can help to identify what caused the problem.
    3. Description: the message associated with the report item.
    4. Project: indicates the project of current row. 
  - The report's columns can be resized, sorted and reordered. 
  - Rows can be copied as text. You can select all and copy the report using the keyboard if you're looking for technical support. 

## System Requirements
- An x64-based OS.
- The system must have GUI.

## How to run it on Windows
1. Extract all files to a folder on your disk.
2. Run the MigrationTool.exe from the Windows Explorer.

## How to run it on macOS
1. Extract all files to a folder on your disk.
2. Update your security settings to allow running untrusted apps, because this tool is not available in the App store, see https://support.apple.com/guide/mac-help/apple-cant-check-app-for-malicious-software-mchleab3a043/mac.
3. Mark the MigrationTool file as executable, see https://support.apple.com/guide/terminal/make-a-file-executable-apdd100908f-06b3-4e63-8a87-32e71241bab4/mac
4. Run the MigrationTool from the file manager.

## How to run it on Linux
1. Extract all files to a folder on your disk.
2. Mark the MigrationTool file as executable, for example run the command `chmod 755 MigrationTool`.
4. Run the MigrationTool from the file manager.
