/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.documents.excel;

import com.grapecity.documents.excel.IRange;
import com.grapecity.documents.excel.IWorkbook;
import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.M;
import com.grapecity.documents.excel.Order;
import com.grapecity.documents.excel.PageContentInfo;
import com.grapecity.documents.excel.PageInfo;
import com.grapecity.documents.excel.PageSettings;
import com.grapecity.documents.excel.PaginationOrientation;
import com.grapecity.documents.excel.PdfSaveOptions;
import com.grapecity.documents.excel.Point;
import com.grapecity.documents.excel.Rectangle;
import com.grapecity.documents.excel.RepeatSetting;
import com.grapecity.documents.excel.Size;
import com.grapecity.documents.excel.Visibility;
import com.grapecity.documents.excel.Workbook;
import com.grapecity.documents.excel.bJ;
import com.grapecity.documents.excel.bK;
import com.grapecity.documents.excel.cA;
import com.grapecity.documents.excel.cn;
import com.grapecity.documents.excel.cy;
import com.grapecity.documents.excel.es;
import com.grapecity.documents.excel.ew;
import com.grapecity.documents.excel.internals.E.aF;
import com.grapecity.documents.excel.internals.E.cI;
import com.grapecity.documents.excel.internals.E.cd;
import com.grapecity.documents.excel.internals.E.t;
import com.grapecity.documents.excel.internals.aX.j;
import com.grapecity.documents.excel.internals.aY.e;
import com.grapecity.documents.excel.internals.bE.aW;
import com.grapecity.documents.excel.internals.bE.ab;
import com.grapecity.documents.excel.internals.bE.bS;
import com.grapecity.documents.excel.internals.bE.bw;
import com.grapecity.documents.excel.internals.bE.ca;
import com.grapecity.documents.excel.internals.bF.U;
import com.grapecity.documents.excel.internals.bF.bY;
import com.grapecity.documents.excel.internals.bF.o;
import com.grapecity.documents.excel.internals.bK.ac;
import com.grapecity.documents.excel.internals.bf.a;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

@aW
public class PrintManager {
    private Log a = LogFactory.getLog(PrintManager.class);
    private HashMap<IWorkbook, es> b = new HashMap();
    private ArrayList<e> c = new ArrayList();

    protected void finalize() throws Throwable {
        if (!this.c.isEmpty()) {
            for (e e2 : this.c) {
                if (e2 == null) continue;
                e2.b();
            }
        }
        super.finalize();
    }

    @aW
    public final void saveWorkbooksToPDF(OutputStream outputStream, List<IWorkbook> list) {
        List<PageInfo> list2 = this.paginate(list);
        this.savePageInfosToPDF(outputStream, list2);
    }

    @aW
    public final void saveWorkbooksToPDF(OutputStream outputStream, List<IWorkbook> list, PdfSaveOptions pdfSaveOptions) {
        List<PageInfo> list2 = this.paginate(list);
        this.savePageInfosToPDF(outputStream, list2, pdfSaveOptions);
    }

    @aW
    public final void saveWorkbooksToPDF(String string, List<IWorkbook> list) {
        this.saveWorkbooksToPDF(string, list, null);
    }

    @aW
    public final void saveWorkbooksToPDF(String string, List<IWorkbook> list, PdfSaveOptions pdfSaveOptions) {
        if (!cI.g(string)) {
            throw new IllegalArgumentException(com.grapecity.documents.excel.internals.bf.a.aN() + string);
        }
        File file = new File(string);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.saveWorkbooksToPDF(fileOutputStream, list, pdfSaveOptions);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @aW
    public final void savePageInfosToPDF(OutputStream outputStream, List<PageInfo> list) {
        com.grapecity.documents.excel.internals.aX.o.a(this, outputStream, list);
    }

    @aW
    public final void savePageInfosToPDF(OutputStream outputStream, List<PageInfo> list, PdfSaveOptions pdfSaveOptions) {
        com.grapecity.documents.excel.internals.aX.o.a(this, outputStream, list, pdfSaveOptions);
    }

    @aW
    public final void savePageInfosToPDF(String string, List<PageInfo> list) {
        this.savePageInfosToPDF(string, list, null);
    }

    @aW
    public final void savePageInfosToPDF(String string, List<PageInfo> list, PdfSaveOptions pdfSaveOptions) {
        if (!cI.g(string)) {
            throw new IllegalArgumentException(com.grapecity.documents.excel.internals.bf.a.aN() + string);
        }
        File file = new File(string);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.savePageInfosToPDF(fileOutputStream, list, pdfSaveOptions);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @aW
    public final List<PageInfo> paginate(List<IWorkbook> list) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        for (IWorkbook iWorkbook : list) {
            arrayList.addAll(this.paginate(iWorkbook));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aW
    public final List<PageInfo> paginate(IWorkbook iWorkbook) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        for (IWorksheet iWorksheet : iWorkbook.getWorksheets()) {
            if (iWorksheet.getVisible() != Visibility.Visible) continue;
            arrayList.addAll(this.paginate(iWorksheet));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aW
    public final List<PageInfo> paginate(IWorksheet iWorksheet) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        List<IRange> list = this.a(iWorksheet).g();
        this.a(iWorksheet).a(this.a(list));
        for (IRange iRange : list) {
            arrayList.addAll(this.paginate(iRange));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aW
    public final List<PageInfo> paginate(IWorksheet iWorksheet, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        List<IRange> list3 = this.a(iWorksheet).g();
        double d2 = this.a(iWorksheet, list, list2);
        for (IRange iRange : list3) {
            arrayList.addAll(this.a(iRange, d2, list, list2));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aW
    public final PageContentInfo generatePageContentInfo(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3) {
        return this.a(iRange, size, n2, n3, bl2, bl3, -1.0, -1, -1, -1, -1, -1, -1, -1, -1, 1.0);
    }

    @aW
    public final void updatePageNumberAndPageSettings(List<PageInfo> list) {
        com.grapecity.documents.excel.internals.aX.o.a(list);
    }

    @aW
    public final void updatePageNumberAndPageSettings(List<PageInfo> list, int n2, int n3) {
        com.grapecity.documents.excel.internals.aX.o.a(list, n2, n3);
    }

    @aW
    public final void appendPage(PDDocument pDDocument, PageInfo pageInfo) {
        this.appendPage(pDDocument, pageInfo, null);
    }

    @aW
    public final void appendPage(PDDocument pDDocument, PageInfo pageInfo, PdfSaveOptions pdfSaveOptions) {
        PageSettings pageSettings = pageInfo.b();
        float f2 = (float)pageSettings.getPaperWidth();
        float f3 = (float)pageSettings.getPaperHeight();
        PDRectangle pDRectangle = new PDRectangle(f2, f3);
        PDPage pDPage = new PDPage(pDRectangle);
        pDDocument.addPage(pDPage);
        this.draw(pDDocument, pDPage, new Rectangle(0.0, 0.0, f2, f3), pageInfo, pdfSaveOptions);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3) {
        this.draw(pDDocument, pDPage, list, n2, n3, Order.OverThenDown);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3, Order order) {
        this.draw(pDDocument, pDPage, list, n2, n3, order, null);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3, Order order, PdfSaveOptions pdfSaveOptions) {
        int n4 = 0;
        float f2 = pDPage.getMediaBox().getWidth() / (float)n3;
        float f3 = pDPage.getMediaBox().getHeight() / (float)n2;
        PDPageContentStream pDPageContentStream = null;
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        for (PageInfo pageInfo : list) {
            int n5 = 0;
            int n6 = 0;
            if (order == Order.OverThenDown) {
                n5 = n4 % n3;
                n6 = n4 / n3;
            } else {
                n5 = n4 / n2;
                n6 = n4 % n2;
            }
            Rectangle rectangle = new Rectangle((float)n5 * f2, (float)n6 * f3, f2, f3);
            bw<e> bw2 = new bw<e>();
            com.grapecity.documents.excel.internals.aX.o.a(this.a(pageInfo.getPageContent().getRange().getWorksheet()), pDDocument, pDPage, pDPageContentStream, rectangle, pageInfo, pdfSaveOptions, bw2);
            ++n4;
            this.c.add((e)bw2.a);
        }
        if (pDPageContentStream != null) {
            try {
                pDPageContentStream.close();
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
    }

    @aW
    public final boolean hasPrintContent(IRange iRange) {
        return this.a(iRange.getWorksheet()).a(iRange);
    }

    @aW
    public final Size getSize(PageContentInfo pageContentInfo) {
        return pageContentInfo.a(this.a(pageContentInfo.getRange().getWorksheet()));
    }

    @aW
    public final Size getSize(IRange iRange) {
        ew ew2 = this.a(iRange.getWorksheet());
        cd cd2 = ew2.f().d(new t(iRange.getRow(), iRange.getColumn(), iRange.getRowCount(), iRange.getColumnCount()));
        cd2.d *= ew2.b().c();
        return new Size(cd2.c, cd2.d);
    }

    public final es a(IWorkbook iWorkbook) {
        es es2 = this.b.get(iWorkbook);
        if (es2 != null) {
            return es2;
        }
        es2 = new es((Workbook)iWorkbook, ((Workbook)iWorkbook).j().q() != null && ((Workbook)iWorkbook).j().q().a() ? 1.0 : 0.96);
        this.b.put(iWorkbook, es2);
        return es2;
    }

    public final ew a(IWorksheet iWorksheet) {
        es es2 = this.a(iWorksheet.getWorkbook());
        return es2.e().a(iWorksheet.getName());
    }

    @aW
    public final List<PageInfo> paginate(IRange iRange) {
        List<PageInfo> list = com.grapecity.documents.excel.internals.aX.o.a(this.a(iRange.getWorksheet()), iRange);
        this.updatePageNumberAndPageSettings(list);
        return list;
    }

    private final List<PageInfo> a(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2) {
        PageSettings pageSettings = this.a(iRange.getWorksheet(), bK.a);
        double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
        double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
        boolean bl2 = true;
        boolean bl3 = true;
        if (iRange.getWorksheet().getPageSetup().getIsPercentScale() || iRange.getWorksheet().getPageSetup().getFitToPagesTall() <= 0) {
            bl2 = false;
        }
        if (iRange.getWorksheet().getPageSetup().getIsPercentScale() || iRange.getWorksheet().getPageSetup().getFitToPagesWide() <= 0) {
            bl3 = false;
        }
        ArrayList<cA> arrayList = this.a(iRange, d4, list, list2, d2, bl2, false);
        ArrayList<M> arrayList2 = this.b(iRange, d3, list, list2, d2, bl3, false);
        List<PageInfo> list3 = this.a(arrayList, arrayList2, iRange.getWorksheet().getPageSetup().getOrder());
        this.updatePageNumberAndPageSettings(list3);
        return list3;
    }

    private int a(List<IRange> list) {
        int n2 = 0;
        for (IRange iRange : list) {
            n2 = Math.max(iRange.getRow() + iRange.getRowCount(), n2);
        }
        return n2;
    }

    private ArrayList<cA> a(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2, double d3, boolean bl2, boolean bl3) {
        ArrayList<cA> arrayList = new ArrayList<cA>();
        int n2 = iRange.getRow();
        int n3 = iRange.getLastRow();
        Object object = null;
        IWorksheet iWorksheet = iRange.getWorksheet();
        boolean bl4 = false;
        boolean bl5 = false;
        if (((bJ)iWorksheet.getPageSetup()).d()) {
            if (((bJ)iWorksheet.getPageSetup()).e() == 3) {
                bl5 = true;
            }
            bl4 = true;
        }
        while (true) {
            int n4 = -1;
            int n5 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getRow() > n2 || repeatSetting.getRange().getLastRow() < n2) continue;
                    if (n2 > repeatSetting.getTitleRowEnd()) {
                        n4 = repeatSetting.getTitleRowStart();
                        n5 = repeatSetting.getTitleRowEnd();
                        break;
                    }
                    if (n2 <= repeatSetting.getTitleRowStart()) break;
                    n2 = repeatSetting.getTitleRowStart();
                    break;
                }
            }
            Object object2 = this.a(iRange, d3, n4, n5, -1, -1, bl4, n2, d2, bl2);
            if (bl4 && bl5) {
                bl4 = false;
            }
            if (object2 == null) break;
            int n6 = ((cA)object2).h;
            int n7 = -1;
            int n8 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getRow() > n6 || repeatSetting.getRange().getLastRow() < n6) continue;
                    if (n6 >= repeatSetting.getTailRowEnd()) break;
                    n7 = repeatSetting.getTailRowStart();
                    n8 = repeatSetting.getTailRowEnd();
                    break;
                }
            }
            if (n7 >= 0 && (object2 = this.a(iRange, d3, n4, n5, n7, n8, bl4, n2, d2, bl2)) == null) break;
            if (list != null && !list.isEmpty()) {
                n6 = ((cA)object2).h;
                for (IRange iRange2 : list) {
                    if (((cn)iRange2).a().get(0).f()) continue;
                    com.grapecity.documents.excel.internals.bF.ca ca2 = this.a(iRange.getWorksheet()).f();
                    double d4 = ca2.b().b(iRange2.getRow(), iRange2.getLastRow());
                    if (d2 < d4) {
                        throw new IllegalStateException(com.grapecity.documents.excel.internals.bf.a.bT());
                    }
                    if (iRange2.getRow() > n6 || iRange2.getLastRow() <= n6) continue;
                    n6 = iRange2.getRow() - 1;
                }
                ((cA)object2).h = n6;
            }
            if (((cA)object2).g > ((cA)object2).h) {
                throw new IllegalStateException(com.grapecity.documents.excel.internals.bf.a.bR());
            }
            if (object != null && ((cA)object).g == ((cA)object2).g && ((cA)object).h == ((cA)object2).h) {
                if (bl3) {
                    return null;
                }
                throw new IllegalStateException(com.grapecity.documents.excel.internals.bf.a.bZ());
            }
            arrayList.add((cA)object2);
            object = object2;
            if (((cA)object2).h >= n3) {
                ((cA)object2).h = n3;
                break;
            }
            n2 = ((cA)object2).h + 1;
        }
        return arrayList;
    }

    private ArrayList<M> b(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2, double d3, boolean bl2, boolean bl3) {
        Object object;
        int n2;
        ArrayList<M> arrayList = new ArrayList<M>();
        int n3 = iRange.getColumn();
        int n4 = iRange.getLastColumn();
        Object object2 = null;
        boolean bl4 = false;
        double d4 = -1.0;
        boolean bl5 = false;
        if (((bJ)iRange.getWorksheet().getPageSetup()).b()) {
            if (((bJ)iRange.getWorksheet().getPageSetup()).c() == 3) {
                bl5 = true;
            }
            bl4 = true;
            n2 = Math.max(String.valueOf(iRange.getLastRow()).length(), 3);
            IWorkbook iWorkbook = iRange.getWorksheet().getWorkbook();
            object = iRange.getWorksheet().getWorkbook();
            d4 = ((Workbook)iWorkbook).b(aF.b) * (double)n2 + 0.36363636363636365 * ((Workbook)object).q().a((int)0).b.c;
        }
        while (true) {
            n2 = -1;
            int n5 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getColumn() > n3 || repeatSetting.getRange().getLastColumn() < n3) continue;
                    if (n3 > repeatSetting.getTitleColumnEnd()) {
                        n2 = repeatSetting.getTitleColumnStart();
                        n5 = repeatSetting.getTitleColumnEnd();
                        break;
                    }
                    if (n3 <= repeatSetting.getTitleColumnStart()) break;
                    n3 = repeatSetting.getTitleColumnStart();
                    break;
                }
            }
            object = this.a(iRange, d3, n2, n5, -1, -1, bl4, d4, n3, d2, bl2);
            if (bl4 && bl5) {
                bl4 = false;
            }
            if (object == null) break;
            int n6 = ((M)object).h;
            int n7 = -1;
            int n8 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getColumn() > n6 || repeatSetting.getRange().getLastColumn() < n6) continue;
                    if (n6 >= repeatSetting.getTailColumnEnd()) break;
                    n7 = repeatSetting.getTailColumnStart();
                    n8 = repeatSetting.getTailColumnEnd();
                    break;
                }
            }
            if (n7 >= 0 && (object = this.a(iRange, d3, n2, n5, n7, n8, bl4, d4, n3, d2, bl2)) == null) break;
            if (list != null && !list.isEmpty()) {
                n6 = ((M)object).h;
                for (IRange iRange2 : list) {
                    if (((cn)iRange2).a().get(0).e()) continue;
                    com.grapecity.documents.excel.internals.bF.ca ca2 = this.a(iRange.getWorksheet()).f();
                    double d5 = ca2.c().b(iRange2.getColumn(), iRange2.getLastColumn());
                    if (d2 < d5) {
                        throw new IllegalStateException(com.grapecity.documents.excel.internals.bf.a.bU());
                    }
                    if (iRange2.getColumn() > n6 || iRange2.getLastColumn() <= n6) continue;
                    n6 = iRange2.getColumn() - 1;
                }
                ((M)object).h = n6;
            }
            if (((M)object).g > ((M)object).h) {
                throw new IllegalStateException(com.grapecity.documents.excel.internals.bf.a.bS());
            }
            if (object2 != null && ((M)object2).g == ((M)object).g && ((M)object2).h == ((M)object).h) {
                if (bl3) {
                    return null;
                }
                throw new IllegalStateException(com.grapecity.documents.excel.internals.bf.a.bY());
            }
            arrayList.add((M)object);
            object2 = object;
            if (((M)object).h >= n4) {
                ((M)object).h = n4;
                break;
            }
            n3 = ((M)object).h + 1;
        }
        return arrayList;
    }

    private final List<cA> a(IRange iRange) {
        return com.grapecity.documents.excel.internals.aX.o.a(this.a(iRange.getWorksheet()), ((cn)iRange).b().get(0));
    }

    private final List<cA> a(IRange iRange, double d2, int n2, boolean bl2) {
        ew ew2 = this.a(iRange.getWorksheet());
        int n3 = ((bJ)ew2.c().getPageSetup()).e();
        if (n3 == 0) {
            n3 = ew2.c().i().aO().g ? 2 : 1;
        }
        cy cy2 = ew2.m();
        PageSettings pageSettings = ew2.a(bK.a);
        double d3 = pageSettings.a().d;
        ArrayList<cA> arrayList = this.a(iRange, d2, bl2, d3, n3, cy2);
        if (n2 <= 0 || arrayList.size() < n2) {
            return arrayList;
        }
        double d4 = 0.0;
        double d5 = d2;
        while (d5 - d4 > 0.1) {
            d2 = (d4 + d5) / 2.0;
            arrayList = this.a(iRange, d2, bl2, d3, n3, cy2);
            if (arrayList.size() < n2) {
                d4 = d2;
                continue;
            }
            d5 = d2;
        }
        return arrayList;
    }

    private ArrayList<cA> a(IRange iRange, double d2, boolean bl2, double d3, int n2, cy cy2) {
        ArrayList<cA> arrayList = new ArrayList<cA>();
        int n3 = iRange.getRow();
        boolean bl3 = n2 == 2 || n2 == 3;
        boolean bl4 = n2 == 3;
        while (true) {
            cA cA2 = this.a(iRange, d2, cy2.a, cy2.b, cy2.c, cy2.d, bl3, n3, d3, bl2, true);
            if (bl3 && bl4) {
                bl3 = false;
            }
            if (cA2 == null) break;
            if (cA2.h >= iRange.getLastRow()) {
                cA2.h = iRange.getLastRow();
                arrayList.add(cA2);
                break;
            }
            arrayList.add(cA2);
            n3 = cA2.h + 1;
        }
        return arrayList;
    }

    private final List<M> b(IRange iRange) {
        return com.grapecity.documents.excel.internals.aX.o.b(this.a(iRange.getWorksheet()), ((cn)iRange).b().get(0));
    }

    private final List<M> a(IRange iRange, double d2, int n2, double d3, boolean bl2) {
        ew ew2 = this.a(iRange.getWorksheet());
        cy cy2 = ew2.m();
        PageSettings pageSettings = ew2.a(bK.a);
        double d4 = pageSettings.a().c;
        ArrayList<M> arrayList = this.a(iRange, d2, bl2, d4, d3, cy2);
        if (n2 <= 0 || arrayList.size() < n2) {
            return arrayList;
        }
        double d5 = 0.0;
        double d6 = d2;
        while (d6 - d5 > 0.1) {
            d2 = (d5 + d6) / 2.0;
            arrayList = this.a(iRange, d2, bl2, d4, d3, cy2);
            if (arrayList.size() < n2) {
                d5 = d2;
                continue;
            }
            d6 = d2;
        }
        return arrayList;
    }

    private ArrayList<M> a(IRange iRange, double d2, boolean bl2, double d3, double d4, cy cy2) {
        M m2;
        ArrayList<M> arrayList = new ArrayList<M>();
        int n2 = iRange.getColumn();
        while ((m2 = this.a(iRange, d2, cy2.a, cy2.b, cy2.c, cy2.d, d4 > 0.0, d4, n2, d3, bl2, true)) != null) {
            if (m2.h >= iRange.getLastColumn()) {
                m2.h = iRange.getLastColumn();
                arrayList.add(m2);
                break;
            }
            arrayList.add(m2);
            n2 = m2.h + 1;
        }
        return arrayList;
    }

    private final List<PageInfo> a(List<cA> list, List<M> list2, Order order) {
        PageInfo pageInfo;
        int n2;
        int n3;
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        t.n();
        t.n();
        if (order == Order.DownThenOver) {
            for (n3 = 0; n3 < list2.size(); ++n3) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!list2.get((int)n3).b.equals(list.get((int)n2).b)) {
                        throw new IllegalStateException();
                    }
                    pageInfo = new PageInfo();
                    pageInfo.setPageContent(new PageContentInfo(list.get(n2), list2.get(n3)));
                    arrayList.add(pageInfo);
                }
            }
        } else {
            for (n3 = 0; n3 < list.size(); ++n3) {
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    if (!list2.get((int)n2).b.equals(list.get((int)n3).b)) {
                        throw new IllegalStateException();
                    }
                    pageInfo = new PageInfo();
                    pageInfo.setPageContent(new PageContentInfo(list.get(n3), list2.get(n2)));
                    arrayList.add(pageInfo);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        if (bS.a(list.get((int)0).b.getPageSetup().getPrintArea()) && bS.a(list.get((int)0).b.getPageSetup().getPrintTitleRows()) && bS.a(list.get((int)0).b.getPageSetup().getPrintTitleColumns())) {
            PageInfo pageInfo2;
            while (!arrayList.isEmpty() && !this.a((pageInfo2 = arrayList.get(arrayList.size() - 1)).getPageContent().getRange().getWorksheet()).a(pageInfo2.getPageContent().getRange())) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Point point, IRange iRange) {
        Size size = this.getSize(iRange);
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)size.getWidth(), (float)size.getHeight()), iRange);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Point point, IRange iRange, PdfSaveOptions pdfSaveOptions) {
        Size size = this.getSize(iRange);
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)size.getWidth(), (float)size.getHeight()), iRange, pdfSaveOptions);
    }

    @aW
    private final void draw(PDDocument pDDocument, PDPage pDPage, Point point, PageContentInfo pageContentInfo) {
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), this.getSize(pageContentInfo).getWidth(), this.getSize(pageContentInfo).getHeight()), pageContentInfo);
    }

    @aW
    private final void draw(PDDocument pDDocument, PDPage pDPage, Point point, PageInfo pageInfo) {
        PageSettings pageSettings = pageInfo.b();
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)pageSettings.getPaperWidth(), (float)pageSettings.getPaperHeight()), pageInfo);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, IRange iRange) {
        this.draw(pDDocument, pDPage, rectangle, iRange, null);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, IRange iRange, PdfSaveOptions pdfSaveOptions) {
        Object object;
        e e2 = new e();
        e2.a();
        PageSettings pageSettings = this.a(iRange.getWorksheet(), bK.a);
        o o2 = new o(false);
        ew ew2 = this.a(iRange.getWorksheet());
        o2.a(ew2, pDDocument, e2, iRange.getRow(), iRange.getColumn(), iRange.getRow() + iRange.getRows().getCount() - 1, iRange.getColumn() + iRange.getColumns().getCount() - 1, pageSettings, pdfSaveOptions);
        com.grapecity.documents.excel.internals.aX.o.a(pDDocument, ew2.b().d());
        if (pdfSaveOptions != null) {
            if (pdfSaveOptions.getDocumentProperties() != null) {
                com.grapecity.documents.excel.internals.aX.o.a(pDDocument, pdfSaveOptions.getDocumentProperties());
            }
            if (pdfSaveOptions.getSecurityOptions() != null) {
                com.grapecity.documents.excel.internals.aX.o.a(pDDocument, pdfSaveOptions.getSecurityOptions());
            }
        }
        j j2 = null;
        PDPageContentStream pDPageContentStream = null;
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            object = ew2.b().d().r();
            j2 = new j(pDDocument, pDPage, pDPageContentStream, e2, pdfSaveOptions, null, (ab)object);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        object = o2.J();
        if (object != null) {
            com.grapecity.documents.excel.internals.bF.ca ca2 = this.a(iRange.getWorksheet()).f();
            double d2 = ca2.b().b(iRange.getRow(), iRange.getRow() + iRange.getRows().getCount() - 1) * ew2.b().c();
            double d3 = ca2.c().b(iRange.getColumn(), iRange.getColumn() + iRange.getColumns().getCount() - 1);
            double d4 = 1.0;
            if (d3 > rectangle.getWidth()) {
                d4 = rectangle.getWidth() / d3;
            }
            double d5 = 1.0;
            if (d2 > rectangle.getHeight()) {
                d5 = rectangle.getHeight() / d2;
            }
            double d6 = d4 < d5 ? d4 : d5;
            ((U)object).d(d6, d6 * ew2.b().c());
            ((U)object).c(rectangle.getX() + (rectangle.getWidth() - (d3 *= d6)) / 2.0, rectangle.getY() + (rectangle.getHeight() - (d2 *= d6)) / 2.0);
            ((U)object).h();
            if (j2 != null) {
                j2.a((U)object);
            }
            try {
                if (pDPageContentStream != null) {
                    pDPageContentStream.close();
                }
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
        this.c.add(e2);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageContentInfo pageContentInfo) {
        this.draw(pDDocument, pDPage, rectangle, pageContentInfo, null);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageContentInfo pageContentInfo, PdfSaveOptions pdfSaveOptions) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageContent(pageContentInfo);
        pageInfo.setPageSettings(this.a(pageContentInfo.getRange().getWorksheet()).a(bK.a));
        Size size = this.getSize(pageContentInfo);
        pageInfo.getPageSettings().setPaperWidth(size.getWidth());
        pageInfo.getPageSettings().setPaperHeight(size.getHeight());
        pageInfo.getPageSettings().setTopMargin(0.0);
        pageInfo.getPageSettings().setBottomMargin(0.0);
        pageInfo.getPageSettings().setLeftMargin(0.0);
        pageInfo.getPageSettings().setRightMargin(0.0);
        this.draw(pDDocument, pDPage, rectangle, pageInfo, pdfSaveOptions);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageInfo pageInfo) {
        this.draw(pDDocument, pDPage, rectangle, pageInfo, null);
    }

    @aW
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageInfo pageInfo, PdfSaveOptions pdfSaveOptions) {
        PDPageContentStream pDPageContentStream = null;
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        bw<e> bw2 = new bw<e>();
        com.grapecity.documents.excel.internals.aX.o.a(this.a(pageInfo.getPageContent().getRange().getWorksheet()), pDDocument, pDPage, pDPageContentStream, rectangle, pageInfo, pdfSaveOptions, bw2);
        this.c.add((e)bw2.a);
        if (pDPageContentStream != null) {
            try {
                pDPageContentStream.close();
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
    }

    private final cA a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, int n6, double d3, boolean bl3) {
        return this.a(iRange, d2, n2, n3, n4, n5, bl2, n6, d3, bl3, false);
    }

    private final cA a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, int n6, double d3, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = n2 >= 0 && n3 >= n2;
        boolean bl7 = bl5 = n4 >= 0 && n5 >= n4;
        if (bl4 && bl6 && n6 < n3) {
            n6 = Math.min(n6, n2);
            n2 = -1;
            n3 = -1;
            bl6 = false;
        }
        cA cA2 = new cA();
        cA2.a = this.a(iRange.getWorksheet());
        cA2.b = iRange.getWorksheet();
        cA2.a(d2);
        cA2.c = n2;
        cA2.d = n3;
        cA2.i = bl2;
        d3 /= this.a(iRange.getWorksheet()).b().c();
        if (d2 > 0.0 && d2 != 1.0) {
            d3 /= d2;
        }
        com.grapecity.documents.excel.internals.bF.ca ca2 = this.a(iRange.getWorksheet()).f();
        bY bY2 = ca2.b();
        if (bl2) {
            d3 -= ca2.i();
        }
        if (bl6) {
            d3 -= bY2.b(n2, n3);
        }
        if (bl5) {
            d3 -= bY2.b(n4, n5);
        }
        if (d3 <= 0.0) {
            return null;
        }
        ca<Integer, Integer> ca3 = bY2.b(n6, d3);
        if ((Integer)ca3.a < 0 || (Integer)ca3.b < 0 || (Integer)ca3.a > iRange.getLastRow()) {
            return null;
        }
        cA2.g = (Integer)ca3.a;
        cA2.h = (Integer)ca3.b;
        if (bl4 && bl5 && cA2.h >= n4) {
            ca3 = bY2.b(n6, d3 += bY2.b(n4, n5));
            cA2.g = (Integer)ca3.a;
            cA2.h = (Integer)ca3.b;
            cA2.e = -1;
            cA2.f = -1;
        } else {
            cA2.e = n4;
            cA2.f = n5;
        }
        cA2.j = -1;
        cA2.k = 0;
        if (!bl3) {
            List<ac> list = this.a(iRange.getWorksheet()).k();
            if (list == null || list.isEmpty()) {
                return cA2;
            }
            for (ac ac2 : list) {
                if (ac2.a > cA2.h) break;
                if (ac2.a <= cA2.g || ac2.b > iRange.getColumn() + iRange.getColumns().getCount() - 1 || ac2.c <= iRange.getColumn()) continue;
                cA2.h = ac2.a - 1;
            }
        }
        if (bl5 && cA2.h < n4) {
            cA2.e = n4;
            cA2.f = n5;
        }
        return cA2;
    }

    private final M a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, double d3, int n6, double d4, boolean bl3) {
        return this.a(iRange, d2, n2, n3, n4, n5, bl2, d3, n6, d4, bl3, false);
    }

    private final M a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, double d3, int n6, double d4, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = n2 >= 0 && n3 >= n2;
        boolean bl7 = bl5 = n4 >= 0 && n5 >= n4;
        if (bl4 && bl6 && n6 < n3) {
            n6 = Math.min(n6, n2);
            n2 = -1;
            n3 = -1;
            bl6 = false;
        }
        M m2 = new M();
        m2.a = this.a(iRange.getWorksheet());
        m2.b = iRange.getWorksheet();
        m2.a(d2);
        m2.c = n2;
        m2.d = n3;
        m2.j = bl2;
        m2.i = d3;
        m2.b = iRange.getWorksheet();
        if (d2 > 0.0 && d2 != 1.0) {
            d4 /= d2;
        }
        com.grapecity.documents.excel.internals.bF.ca ca2 = this.a(iRange.getWorksheet()).f();
        bY bY2 = ca2.c();
        if (bl2) {
            d4 -= d3;
        }
        if (bl6) {
            d4 -= bY2.b(n2, n3);
        }
        if (bl5) {
            d4 -= bY2.b(n4, n5);
        }
        if (d4 <= 0.0) {
            return null;
        }
        ca<Integer, Integer> ca3 = bY2.b(n6, d4);
        if ((Integer)ca3.a < 0 || (Integer)ca3.b < 0 || (Integer)ca3.a > iRange.getLastColumn()) {
            return null;
        }
        m2.g = (Integer)ca3.a;
        m2.h = (Integer)ca3.b;
        if (bl5 && m2.h >= n4) {
            ca3 = bY2.b(n6, d4 += bY2.b(n4, n5));
            m2.g = (Integer)ca3.a;
            m2.h = (Integer)ca3.b;
            m2.e = -1;
            m2.f = -1;
        } else {
            m2.e = n4;
            m2.f = n5;
        }
        m2.l = 0;
        m2.k = -1;
        if (!bl3) {
            List<ac> list = this.a(iRange.getWorksheet()).l();
            if (list == null || list.isEmpty()) {
                return m2;
            }
            for (ac ac2 : list) {
                if (ac2.a > m2.h) break;
                if (ac2.a <= m2.g || ac2.b > iRange.getRow() + iRange.getRows().getCount() - 1 || ac2.c <= iRange.getRow()) continue;
                m2.h = ac2.a - 1;
            }
        }
        if (bl5 && m2.h < n4) {
            m2.e = n4;
            m2.f = n5;
        }
        return m2;
    }

    public final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3, boolean bl4) {
        return this.a(iRange, size, n2, n3, bl2, bl3, d2, n4, n5, n6, n7, n8, n9, n10, n11, d3, bl4, false);
    }

    private final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3) {
        return this.a(iRange, size, n2, n3, bl2, bl3, d2, n4, n5, n6, n7, n8, n9, n10, n11, d3, false, false);
    }

    private final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3, boolean bl4, boolean bl5) {
        PageContentInfo pageContentInfo = new PageContentInfo();
        pageContentInfo.setZoomFactor(d3);
        pageContentInfo.setTitleRowStart(n4);
        pageContentInfo.setTitleRowEnd(n5);
        pageContentInfo.setTailRowStart(n6);
        pageContentInfo.setTailRowEnd(n7);
        pageContentInfo.setColumnHeaderVisible(bl3);
        pageContentInfo.setTitleColumnStart(n8);
        pageContentInfo.setTitleColumnEnd(n9);
        pageContentInfo.setTailColumnStart(n10);
        pageContentInfo.setTailColumnEnd(n11);
        pageContentInfo.setRowHeaderVisible(bl2);
        pageContentInfo.a(d2);
        pageContentInfo.b(0);
        pageContentInfo.a(-1);
        pageContentInfo.d(0);
        pageContentInfo.c(-1);
        pageContentInfo.a(this.a(iRange.getWorksheet()), iRange, n2, n3, size, bl4, bl5, false);
        return pageContentInfo;
    }

    @aW
    public final List<IRange> getPrintAreas(IWorksheet iWorksheet) {
        return this.a(iWorksheet).g();
    }

    public final PageSettings a(IWorksheet iWorksheet, bK bK2) {
        return this.a(iWorksheet).a(bK2);
    }

    @aW
    public List<Integer> GetPaginationInfo(IWorksheet iWorksheet, PaginationOrientation paginationOrientation) {
        if (paginationOrientation == PaginationOrientation.Horizontal) {
            return com.grapecity.documents.excel.internals.aX.o.b(this.a(iWorksheet));
        }
        return com.grapecity.documents.excel.internals.aX.o.c(this.a(iWorksheet));
    }

    @aW
    public List<Integer> GetPaginationInfo(IWorksheet iWorksheet, PaginationOrientation paginationOrientation, List<IRange> list, List<RepeatSetting> list2) {
        List<IRange> list3 = this.a(iWorksheet).g();
        if (list3.isEmpty()) {
            return null;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        if (iWorksheet.getPageSetup().getIsPercentScale() || iWorksheet.getPageSetup().getFitToPagesTall() <= 0) {
            bl2 = false;
        }
        if (iWorksheet.getPageSetup().getIsPercentScale() || iWorksheet.getPageSetup().getFitToPagesWide() <= 0) {
            bl3 = false;
        }
        double d2 = this.a(iWorksheet, list, list2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (IRange iRange : list3) {
            ArrayList<Object> arrayList2;
            PageSettings pageSettings = this.a(iWorksheet, bK.a);
            double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
            double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
            if (paginationOrientation == PaginationOrientation.Horizontal) {
                arrayList2 = this.b(iRange, d3, list, list2, d2, bl3, false);
                for (Object object : arrayList2) {
                    arrayList.add(((M)object).h);
                }
                continue;
            }
            arrayList2 = this.a(iRange, d4, list, list2, d2, bl2, false);
            for (Object object : arrayList2) {
                arrayList.add(((cA)object).h);
            }
        }
        return arrayList;
    }

    private double a(IWorksheet iWorksheet, List<IRange> list, List<RepeatSetting> list2) {
        List<IRange> list3 = this.a(iWorksheet).g();
        if (list3.isEmpty()) {
            return 1.0;
        }
        if (iWorksheet.getPageSetup().getIsPercentScale()) {
            return (double)iWorksheet.getPageSetup().getZoom() / 100.0;
        }
        double d2 = 1.0;
        for (IRange iRange : list3) {
            PageSettings pageSettings = this.a(iWorksheet, bK.a);
            double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
            double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
            Size size = new Size(d3, d4);
            d2 = this.a(this.a(iRange.getWorksheet()), iRange, size, d2, list, list2);
        }
        d2 = (double)((int)(d2 * 100.0)) / 100.0;
        return d2;
    }

    private double a(ew ew2, IRange iRange, Size size, double d2, List<IRange> list, List<RepeatSetting> list2) {
        if (ew2.c().getPageSetup().getFitToPagesTall() > 0) {
            d2 = this.a(iRange, size.getHeight(), ew2.c().getPageSetup().getFitToPagesTall(), d2, list, list2);
        }
        if (ew2.c().getPageSetup().getFitToPagesWide() > 0) {
            d2 = this.b(iRange, size.getWidth(), ew2.c().getPageSetup().getFitToPagesWide(), d2, list, list2);
        }
        return d2;
    }

    private double a(IRange iRange, double d2, int n2, double d3, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<cA> arrayList = this.a(iRange, d2, list, list2, d3, true, true);
        if (arrayList != null && arrayList.size() <= n2) {
            return d3;
        }
        double d4 = d3;
        double d5 = 0.0;
        double d6 = arrayList == null ? d3 / 2.0 : (double)n2 * d3 / (double)arrayList.size();
        int n3 = 0;
        while (n3++ < 20) {
            arrayList = this.a(iRange, d2, list, list2, d6, true, true);
            if (arrayList == null || arrayList.size() > n2) {
                d4 = d6;
            } else {
                d5 = d6;
            }
            if (Math.abs(d4 - d5) < 0.01) break;
            d6 = (d4 + d5) / 2.0;
        }
        if (arrayList != null && arrayList.size() > n2) {
            d6 = d5;
        }
        return d6;
    }

    private double b(IRange iRange, double d2, int n2, double d3, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<M> arrayList = this.b(iRange, d2, list, list2, d3, true, true);
        if (arrayList != null && arrayList.size() <= n2) {
            return d3;
        }
        double d4 = d3;
        double d5 = 0.0;
        double d6 = arrayList == null ? d3 / 2.0 : (double)n2 * d3 / (double)arrayList.size();
        int n3 = 0;
        while (n3++ < 20) {
            arrayList = this.b(iRange, d2, list, list2, d6, true, true);
            if (arrayList == null || arrayList.size() > n2) {
                d4 = d6;
            } else {
                d5 = d6;
            }
            if (Math.abs(d4 - d5) < 0.01) break;
            d6 = (d4 + d5) / 2.0;
        }
        if (arrayList != null && arrayList.size() > n2) {
            d6 = d5;
        }
        return d6;
    }
}

