/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.documents.excel;

import com.grapecity.documents.excel.CancellationToken;
import com.grapecity.documents.excel.DeserializationOptions;
import com.grapecity.documents.excel.Event;
import com.grapecity.documents.excel.EventArgs;
import com.grapecity.documents.excel.EventHandler;
import com.grapecity.documents.excel.FontInfo;
import com.grapecity.documents.excel.IBuiltInDocumentPropertyCollection;
import com.grapecity.documents.excel.ICustomDocumentPropertyCollection;
import com.grapecity.documents.excel.ICustomViews;
import com.grapecity.documents.excel.IExcelOptions;
import com.grapecity.documents.excel.IGraphicsInfo;
import com.grapecity.documents.excel.IIconSets;
import com.grapecity.documents.excel.INames;
import com.grapecity.documents.excel.IPivotCaches;
import com.grapecity.documents.excel.ISignatureSet;
import com.grapecity.documents.excel.ISlicerCaches;
import com.grapecity.documents.excel.IStyleCollection;
import com.grapecity.documents.excel.ITableStyleCollection;
import com.grapecity.documents.excel.ITheme;
import com.grapecity.documents.excel.IWorkbookView;
import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.IWorksheets;
import com.grapecity.documents.excel.JsonError;
import com.grapecity.documents.excel.OpenFileFormat;
import com.grapecity.documents.excel.OpenOptionsBase;
import com.grapecity.documents.excel.RangeEventArgs;
import com.grapecity.documents.excel.ReferenceStyle;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.SaveOptionsBase;
import com.grapecity.documents.excel.SerializationOptions;
import com.grapecity.documents.excel.SheetEventArgs;
import com.grapecity.documents.excel.SjsOpenOptions;
import com.grapecity.documents.excel.SjsSaveOptions;
import com.grapecity.documents.excel.WriteProtection;
import com.grapecity.documents.excel.drawing.ImageType;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;

public interface IWorkbook {
    public Event<EventHandler<EventArgs>> getAfterSaveEvent();

    public Event<EventHandler<EventArgs>> getBeforeSaveEvent();

    public Event<EventHandler<SheetEventArgs>> getNewSheetEvent();

    public Event<EventHandler<EventArgs>> getOpenedEvent();

    public Event<EventHandler<SheetEventArgs>> getSheetActivateEvent();

    public Event<EventHandler<SheetEventArgs>> getSheetBeforeDeleteEvent();

    public Event<EventHandler<RangeEventArgs>> getSheetChangeEvent();

    public Event<EventHandler<SheetEventArgs>> getSheetDeactivateEvent();

    public Event<EventHandler<RangeEventArgs>> getSheetSelectionChange();

    @Deprecated
    public boolean getAllowDynamicArray();

    @Deprecated
    public void setAllowDynamicArray(boolean var1);

    public boolean getDeferUpdateDirtyState();

    public void setDeferUpdateDirtyState(boolean var1);

    public String getName();

    public void setName(String var1);

    public String getFullName();

    public String getPath();

    public void setPath(String var1);

    public IWorksheets getSelectedSheets();

    public IExcelOptions getOptions();

    public boolean getResetAdjacentRangeBorder();

    public void setResetAdjacentRangeBorder(boolean var1);

    public boolean getAutoParse();

    public void setAutoParse(boolean var1);

    public boolean getAutoRoundValue();

    public void setAutoRoundValue(boolean var1);

    public IWorkbookView getBookView();

    public boolean getProtectStructure();

    public boolean getProtectWindows();

    public ISignatureSet getSignatures();

    public IBuiltInDocumentPropertyCollection getBuiltInDocumentProperties();

    public ICustomDocumentPropertyCollection getCustomDocumentProperties();

    public ICustomViews getCustomViews();

    public WriteProtection getWriteProtection();

    public boolean getEnableCalculation();

    public void setEnableCalculation(boolean var1);

    public Locale getCulture();

    public void setCulture(Locale var1);

    public String getDefaultTableStyle();

    public void setDefaultTableStyle(String var1);

    public INames getNames();

    public String getAuthor();

    public void setAuthor(String var1);

    public IPivotCaches getPivotCaches();

    public ReferenceStyle getReferenceStyle();

    public void setReferenceStyle(ReferenceStyle var1);

    public IStyleCollection getStyles();

    public ITableStyleCollection getTableStyles();

    public ITheme getTheme();

    public void setTheme(ITheme var1);

    public IIconSets getIconSets();

    public IWorksheets getWorksheets();

    public IWorksheet getActiveSheet();

    public ISlicerCaches getSlicerCaches();

    public void calculate();

    public void dirty();

    public List<JsonError> fromJson(String var1);

    public List<JsonError> fromJson(String var1, DeserializationOptions var2);

    public List<JsonError> fromJson(InputStream var1);

    public List<JsonError> fromJson(InputStream var1, DeserializationOptions var2);

    public String toJson();

    public String toJson(SerializationOptions var1);

    public void toJson(OutputStream var1);

    public void toJson(OutputStream var1, SerializationOptions var2);

    public boolean isEncryptedFile(String var1);

    public boolean isEncryptedFile(InputStream var1);

    public void open(String var1);

    public List<JsonError> open(String var1, DeserializationOptions var2);

    public void open(String var1, String var2);

    public void open(String var1, OpenOptionsBase var2);

    public void open(String var1, OpenFileFormat var2);

    public void open(InputStream var1);

    public void open(InputStream var1, String var2);

    public void open(InputStream var1, OpenOptionsBase var2);

    public void open(InputStream var1, OpenFileFormat var2);

    public void save(String var1);

    public void save(String var1, String var2);

    public void save(String var1, SaveOptionsBase var2);

    public void save(String var1, SaveFileFormat var2);

    public void save(OutputStream var1);

    public void save(OutputStream var1, String var2);

    public void save(OutputStream var1, SaveOptionsBase var2);

    public void save(OutputStream var1, SaveFileFormat var2);

    public List<FontInfo> getUsedFonts();

    public void protect();

    public void protect(boolean var1);

    public void protect(boolean var1, boolean var2);

    public void protect(String var1);

    public void protect(String var1, boolean var2);

    public void protect(String var1, boolean var2, boolean var3);

    public void unprotect();

    public void unprotect(String var1);

    public void addDataSource(String var1, Object var2);

    public void processTemplate();

    public void processTemplate(CancellationToken var1);

    public IWorkbook generateReport();

    public IWorkbook generateReport(IWorksheet ... var1);

    public IGraphicsInfo getGraphicsInfo();

    public void setGraphicsInfo(IGraphicsInfo var1);

    public List<String> getExcelLinkSources();

    public void updateExcelLink(String var1);

    public void updateExcelLink(String var1, IWorkbook var2);

    public void updateExcelLinks();

    public String toSjsJson();

    public String toSjsJson(SjsSaveOptions var1);

    public void toSjsJson(OutputStream var1, SjsSaveOptions var2);

    public void toSjsJson(OutputStream var1);

    public void convertBarcodeToPicture();

    public void convertBarcodeToPicture(ImageType var1);

    public void fromSjsJson(String var1);

    public void fromSjsJson(String var1, SjsOpenOptions var2);

    public void fromSjsJson(InputStream var1, SjsOpenOptions var2);

    public void fromSjsJson(InputStream var1);

    public void waitForCalculationToFinish();

    public boolean getShowPivotTableFieldList();

    public void setShowPivotTableFieldList(boolean var1);
}

